/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeWatch
extends PEToggleItem
implements IPedestalItem,
IItemCharge,
IBarHelper {
    public TimeWatch(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (!ProjectEConfig.server.items.enableTimeWatch.get()) {
                player.m_6352_((Component)PELang.TIME_WATCH_DISABLED.translate(new Object[0]), Util.f_137441_);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            byte current = this.getTimeBoost(stack);
            this.setTimeBoost(stack, (byte)(current == 2 ? 0 : current + 1));
            player.m_6352_((Component)PELang.TIME_WATCH_MODE_SWITCH.translate(this.getTimeName(stack)), Util.f_137441_);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int invSlot, boolean isHeld) {
        float mobSlowdown;
        int bonusTicks;
        Player player;
        block16: {
            block15: {
                super.m_6883_(stack, level, entity, invSlot, isHeld);
                if (!(entity instanceof Player)) break block15;
                player = (Player)entity;
                if (invSlot < Inventory.m_36059_() && ProjectEConfig.server.items.enableTimeWatch.get()) break block16;
            }
            return;
        }
        byte timeControl = this.getTimeBoost(stack);
        if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46140_)) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (timeControl == 1) {
                serverWorld.m_8615_(Math.min(level.m_46468_() + (long)(this.getCharge(stack) + 1) * 4L, Long.MAX_VALUE));
            } else if (timeControl == 2) {
                long charge = this.getCharge(stack) + 1;
                if (level.m_46468_() - charge * 4L < 0L) {
                    serverWorld.m_8615_(0L);
                } else {
                    serverWorld.m_8615_(level.m_46468_() - charge * 4L);
                }
            }
        }
        if (level.f_46443_ || !ItemHelper.checkItemNBT(stack, "Active")) {
            return;
        }
        long reqEmc = EMCHelper.removeFractionalEMC(stack, this.getEmcPerTick(this.getCharge(stack)));
        if (!TimeWatch.consumeFuel(player, stack, reqEmc, true)) {
            return;
        }
        int charge = this.getCharge(stack);
        if (charge == 0) {
            bonusTicks = 8;
            mobSlowdown = 0.25f;
        } else if (charge == 1) {
            bonusTicks = 12;
            mobSlowdown = 0.16f;
        } else {
            bonusTicks = 16;
            mobSlowdown = 0.12f;
        }
        AABB bBox = player.m_142469_().m_82400_(8.0);
        this.speedUpBlockEntities(level, bonusTicks, bBox);
        this.speedUpRandomTicks(level, bonusTicks, bBox);
        this.slowMobs(level, bBox, mobSlowdown);
    }

    private void slowMobs(Level level, AABB bBox, double mobSlowdown) {
        if (bBox == null) {
            return;
        }
        for (Mob ent : level.m_45976_(Mob.class, bBox)) {
            ent.m_20256_(ent.m_20184_().m_82542_(mobSlowdown, 1.0, mobSlowdown));
        }
    }

    private void speedUpBlockEntities(Level level, int bonusTicks, AABB bBox) {
        if (bBox == null || bonusTicks == 0) {
            return;
        }
        for (BlockEntity blockEntity : WorldHelper.getBlockEntitiesWithinAABB(level, bBox)) {
            BlockPos pos;
            if (blockEntity.m_58901_() || PETags.BlockEntities.BLACKLIST_TIME_WATCH_LOOKUP.contains(blockEntity.m_58903_()) || !level.m_183438_(ChunkPos.m_151388_((BlockPos)(pos = blockEntity.m_58899_())))) continue;
            LevelChunk chunk = level.m_46745_(pos);
            LevelChunk.RebindableTickingBlockEntityWrapper tickingWrapper = (LevelChunk.RebindableTickingBlockEntityWrapper)chunk.f_156362_.get(pos);
            if (tickingWrapper == null || tickingWrapper.m_142220_()) continue;
            TickingBlockEntity tickingBlockEntity = tickingWrapper.f_156444_;
            if (tickingBlockEntity instanceof LevelChunk.BoundTickingBlockEntity) {
                LevelChunk.BoundTickingBlockEntity tickingBE = (LevelChunk.BoundTickingBlockEntity)tickingBlockEntity;
                if (!chunk.m_156410_(pos)) continue;
                ProfilerFiller profiler = level.m_46473_();
                profiler.m_6521_(() -> ((LevelChunk.RebindableTickingBlockEntityWrapper)tickingWrapper).m_142280_());
                BlockState state = chunk.m_8055_(pos);
                if (blockEntity.m_58903_().m_155262_(state)) {
                    for (int i = 0; i < bonusTicks; ++i) {
                        tickingBE.f_156429_.m_155252_(level, pos, state, blockEntity);
                    }
                }
                profiler.m_7238_();
                continue;
            }
            for (int i = 0; i < bonusTicks; ++i) {
                tickingWrapper.m_142224_();
            }
        }
    }

    private void speedUpRandomTicks(Level level, int bonusTicks, AABB bBox) {
        if (bBox == null || bonusTicks == 0 || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            if (!WorldHelper.isBlockLoaded((BlockGetter)serverLevel, pos)) continue;
            BlockState state = serverLevel.m_8055_(pos);
            Block block = state.m_60734_();
            if (!state.m_60823_() || state.m_204336_(PETags.Blocks.BLACKLIST_TIME_WATCH) || block instanceof LiquidBlock || block instanceof BonemealableBlock || block instanceof IPlantable) continue;
            pos = pos.m_7949_();
            for (int i = 0; i < bonusTicks; ++i) {
                state.m_60735_(serverLevel, pos, serverLevel.f_46441_);
            }
        }
    }

    private ILangEntry getTimeName(ItemStack stack) {
        byte mode = this.getTimeBoost(stack);
        return switch (mode) {
            case 0 -> PELang.TIME_WATCH_OFF;
            case 1 -> PELang.TIME_WATCH_FAST_FORWARD;
            case 2 -> PELang.TIME_WATCH_REWIND;
            default -> PELang.INVALID_MODE;
        };
    }

    private byte getTimeBoost(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_128445_("TimeMode") : (byte)0;
    }

    private void setTimeBoost(ItemStack stack, byte time) {
        stack.m_41784_().m_128344_("TimeMode", (byte)Mth.m_14045_((int)time, (int)0, (int)2));
    }

    public double getEmcPerTick(int charge) {
        return (double)(charge + 2) / 2.0;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add((Component)PELang.TOOLTIP_TIME_WATCH_1.translate(new Object[0]));
        tooltips.add((Component)PELang.TOOLTIP_TIME_WATCH_2.translate(new Object[0]));
        if (stack.m_41782_()) {
            tooltips.add((Component)PELang.TIME_WATCH_MODE.translate(this.getTimeName(stack)));
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.items.enableTimeWatch.get()) {
            AABB bBox = ((IDMPedestal)pedestal).getEffectBounds();
            if (ProjectEConfig.server.effects.timePedBonus.get() > 0) {
                this.speedUpBlockEntities(level, ProjectEConfig.server.effects.timePedBonus.get(), bBox);
                this.speedUpRandomTicks(level, ProjectEConfig.server.effects.timePedBonus.get(), bBox);
            }
            if (ProjectEConfig.server.effects.timePedMobSlowness.get() < 1.0) {
                this.slowMobs(level, bBox, ProjectEConfig.server.effects.timePedMobSlowness.get());
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.effects.timePedBonus.get() > 0) {
            list.add((Component)PELang.PEDESTAL_TIME_WATCH_1.translateColored(ChatFormatting.BLUE, ProjectEConfig.server.effects.timePedBonus.get()));
        }
        if (ProjectEConfig.server.effects.timePedMobSlowness.get() < 1.0) {
            list.add((Component)PELang.PEDESTAL_TIME_WATCH_2.translateColored(ChatFormatting.BLUE, String.format("%.3f", ProjectEConfig.server.effects.timePedMobSlowness.get())));
        }
        return list;
    }

    @Override
    public int getNumCharges(@NotNull ItemStack stack) {
        return 2;
    }

    @Override
    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }
}

